package messages

import "code.justin.tv/gds/gds/golibs/event"

const (
	ChannelTopic              = event.Topic("channel")
	OnInstalled               = event.Change("install")
	OnUninstalled             = event.Change("uninstall")
	OnActivated               = event.Change("activate")
	OnDynamicActivated        = event.Change("dynamic_activate")
	OnDeactivated             = event.Change("deactivate")
	OnDynamicDeactivated      = event.Change("dynamic_deactivate")
	OnAnchorChanged           = event.Change("anchor_changed")
	OnConfigured              = event.Change("configuration_valid")
	OnDynamicInstalled        = event.Change("dynamic_management_installed")
	OnDynamicEnrolled         = event.Change("dynamic_management_enrolled")
	OnDynamicUninstalled      = event.Change("dynamic_management_uninstalled")
	OnDynamicUnenrolled       = event.Change("dynamic_management_unenrolled")
	OnManualDynamicUnenrolled = event.Change("dynamic_management_manual_unenrolled")
	OnPermsAllowed            = event.Change("broadcaster_permissions_allowed")
	OnPermsDenied             = event.Change("broadcaster_permissions_denied")

	ExtensionTopic    = event.Topic("extension")
	OnCreated         = event.Change("create")
	OnModified        = event.Change("modify") // also valid for assets
	OnDeleted         = event.Change("delete")
	OnTransitioned    = event.Change("state_transition")
	OnMassDeactivated = event.Change("mass_deactivate")

	AssetTopic = event.Topic("asset")
	OnSaved    = event.Change("saved")

	// MaybeActivated is a new message that is sent when HostedConfig is the only required action left.
	// For extensions with HostedConfigurations required, EMS cannot determine if the HostedConfig has actually been set.
	// Without sending this message, ECS would not be able to know when extensions with HostedConfigs are live.
	OnMaybeActivated        = event.Change("maybe_activated")
	OnDynamicMaybeActivated = event.Change("dynamic_maybe_activated")
)
