package data

import "code.justin.tv/gds/gds/extensions/ems/documents"

const (
	// Anchor : every install must declare its attachment point
	Anchor = documents.Anchor
	// Configure : every install must be properly configured
	Configure = documents.Configure
	// HostedConfig : Pending Information from configuration service
	HostedConfig = documents.HostedConfig
	// Release : this was a public install but the extension was unpublished
	Release = documents.Release
	// Unknown : unable to interpret this value, code is likely out of date
	Unknown = documents.Unknown
)

// ActivationRequirements is a slice of activations with a few additional
// functions defined.
type ActivationRequirements []documents.ActivationRequirement

func ToActivationRequirement(name string) documents.ActivationRequirement {
	switch name {
	case string(Anchor):
		return Anchor
	case string(Configure):
		return Configure
	case string(Release):
		return Release
	default:
		return Unknown
	}
}
