package data

import (
	"code.justin.tv/gds/gds/extensions/ems/documents"
)

//go:generate counterfeiter -o ./fakes/fake_channel.go . Channel

type Channel interface {
	ClearAnchor(anchor *ExtensionAnchor) Channel
	ClearAnchorFor(id string, version *string, manageDynamicSettings bool) Channel
	FindExtension(string, string, *string) (*string, error)
	GetExtensionInstallationOAuth(forExtensionID string) (string, error)
	HardDelete() error
	HasInstalled(id, version string) bool
	Install(Request) Channel
	MarkDynamic() Channel
	PendingRequirements(id string, version *string) (ActivationRequirements, error)
	Save() error
	SetAnchor(id string, version *string, anchor documents.AnchorParam, manageDynamicSettings bool) Channel
	SetConfiguration(id, version, config string) Channel
	SetFeatureFlags(id, version string, flags documents.SetFeatureFlagsDocument) Channel
	SetBroadcasterOAuth(id, version, oauthToken string) Channel
	ToActivationDocument(id string, version *string) (*documents.ActivationDocument, error)
	ToActivationsDocument() (*documents.ActivationsDocument, error)
	ToInstallationStatusDocument(id string, version *string) (*documents.InstallationStatusDocument, error)
	ToInstalledExtensionDocument(id string, version *string) (*documents.InstalledExtensionDocument, error)
	ToInstalledExtensionsDocument() (*documents.InstalledExtensionsDocument, error)
	ToPostActivationConfigDocument(id string, version *string) (*documents.PostActivationConfigDocument, error)
	Uninstall(Request) Channel
}
