package data

import (
	"net/http"

	"github.com/jixwanwang/apiutils"
)

var (
	// ErrInvalidFormat is returned by a store when a load request can't be fulfilled
	ErrInvalidFormat = apiutils.NewErrorResponse(http.StatusConflict, "The record had the wrong format")
	// ErrNotFound is returned by a store when a load request can't be fulfilled
	ErrNotFound = apiutils.NewErrorResponse(http.StatusNotFound, "The record was not found")
	// ErrConcurrency is returned by a store when save requests collide
	ErrConcurrency = apiutils.NewErrorResponse(http.StatusConflict, "Concurrency violation")
	// ErrNotImplemented is a convenience error so things can conform to an interface before they're done
	ErrNotImplemented = apiutils.NewErrorResponse(http.StatusNotImplemented, "Not implemented yet")
	// ErrUnavailable indicates that a context temporarily doesn't support functionality
	ErrUnavailable = apiutils.NewErrorResponse(http.StatusServiceUnavailable, "Service not available")
	// ErrTooManyRequests is thrown if a store is under too much request pressure and requires a cooldown period
	ErrTooManyRequests = apiutils.NewErrorResponse(http.StatusTooManyRequests, "Too many requests")
	// ErrNeedSlot is returned when an extension activation configuration does not contain a slot
	ErrNeedSlot = apiutils.NewErrorResponse(http.StatusUnprocessableEntity, "Extension activation configuration must contain nonempty 'slot'")
	// ErrNeedAnchor is returned when an extension activation configuration does not contain an anchor
	ErrNeedAnchor = apiutils.NewErrorResponse(http.StatusUnprocessableEntity, "Extension activation configuration must contain nonempty 'anchor'")
	// ErrBroadcasterNotWhitelisted is returned when a user tries to install an extension but they're not on the broadcaster whitelist
	ErrBroadcasterNotWhitelisted = apiutils.NewErrorResponse(http.StatusForbidden, "Sorry, you're not on the broadcaster whitelist for that extension")
	// ErrIllegalWhileDeleted is returned if an attempt is made to modify a version or summary that has been deleted
	ErrIllegalWhileDeleted = apiutils.NewErrorResponse(http.StatusConflict, "Operation is not permitted on deleted extensions")
	// ErrNonAtomicWrite is returned if a route attempts to modify a record multiple times in parallel
	ErrNonAtomicWrite = apiutils.NewErrorResponse(http.StatusConflict, "This save is not atomic; rejected")
	// ErrDataIsLocked is returned if a route attempts to modify a record that is
	ErrDataIsLocked = apiutils.NewErrorResponse(http.StatusConflict, "This version can't be updated in this state")
	// ErrTooManyInstallations is returned when the user attempts to install an installation when they've already installed
	// the maximum or more (in the event that they already installed more than the max prior to adding the limit)
	ErrTooManyInstallations = apiutils.NewErrorResponse(http.StatusConflict, "Too many installations")
)
