package data

import (
	"code.justin.tv/gds/gds/extensions/ems/documents"
	"code.justin.tv/gds/gds/extensions/ems/protocol"
	"code.justin.tv/gds/gds/extensions/models"
)

//go:generate counterfeiter -o ./fakes/fake_extension.go . Extension

type Extension interface {
	ExtensionDiscovery
	Saver
	UpdateDataOld(manifest *documents.Manifest) Saver
	UpdateDataV2(manifest *protocol.ExtensionManifest) Saver
	UpdateDataV3(manifest *protocol.ExtensionManifest) Saver
	UpdateState(state ExtensionState) Saver
	UpdateAsset(info AssetInfo) Saver
	AddIconUrl(iconSize protocol.IconSize, url string) Saver
	AddScreenshotUrl(url string) Saver
	Clone(newVersion string) (Extension, error)
	RemoveImageUrls(urls []string) Saver
	SetDeleted(deleted bool) Saver
	HardDeleteAll() error
	ToExtensionAuthorEmailDocument() *documents.ExtensionAuthorEmailDocument
	ToExtensionDocument() *documents.ExtensionDocument
	ToExtensionManifest() (*protocol.ExtensionManifest, error)
	ToAdminExtensionDocument() *models.Extension
	RemoveUserFromTestingAccounts(userID string) error
	RemoveUserFromBroadcasterWhitelist(userID, dummyValue string) (bool, error)
	SetAdministrativelyHidden(value bool) Saver
}
