package data

import "code.justin.tv/gds/gds/extensions/ems/protocol"

type ExtensionDiscovery interface {
	SetCategory(cid string) Saver
	SetDescription(description string) Saver
	AddGame(gid int) Saver
	DeleteGame(gid int) Saver
	SetDiscoveryMetadata(metadata *protocol.DiscoveryMetadata, bitsEnabled bool, bitsLevel protocol.BitsSupportLevel, chatSupport bool, subLevel protocol.SubscriptionsSupportLevel) Saver
	SetDiscoveryImages(metadata *protocol.DiscoveryMetadata) Saver
	// CopyDiscoveryMetadataFrom copies the discovery metadata from another extension/version
	// to this one.  It is similar to clone for just the discovery data but it *will not*
	// create a new version.
	CopyDiscoveryMetadataFrom(source Extension, bitsEnabled bool, bitsLevel protocol.BitsSupportLevel, chatSupport bool, subLevel protocol.SubscriptionsSupportLevel) Saver
}
