package data

import (
	"context"

	"code.justin.tv/gds/gds/extensions/ems/client/messages"

	"code.justin.tv/gds/gds/extensions/ems/documents"
	"code.justin.tv/gds/gds/extensions/ems/protocol"
	"code.justin.tv/gds/gds/golibs/event"
)

//go:generate counterfeiter -o ./fakes/fake_extension_manager.go . ExtensionManager

type ExtensionManager interface {
	CreateVersionOld(*documents.Manifest) error
	CreateVersionV2(*protocol.ExtensionManifest) (Extension, error)
	CreateVersionV3(*protocol.ExtensionManifest) (Extension, error)
	DeleteExtension(extensionID string) error
	GetAllVersions(extensionID string) ([]Extension, error)
	PagedGetVersions(extensionID string, token *string) ([]Extension, bool, *string, error)
	GetExtensions(Request) ([]Extension, error)
	GetExtensionSummary(extensionID string) (*protocol.ExtensionSummary, error)
	GetAssetInfo(extensionID string, assetHash string) (AssetInfo, error)
	AddAssetInfo(*protocol.AssetInfo) (AssetInfo, error)
	GetChannel(channelID string) (Channel, error)

	// search
	Fields() (*documents.SearchSortFieldsDocument, error)
	FindExtensions(*SearchSettings, *documents.GetExtensionsParams) (*documents.ExtensionsDocument, error)
	DeleteExtensionsFromSearch([]string) (int, error)
	FindChannelInstalls(string) ([]*messages.ChannelMessage, error)
	DeleteChannelFromSearch(string) (int, error)

	// events
	Register(listener event.Listener) error

	// for testing use; requires that store.EnableDataReset() was called previously
	IsResetEnabled() bool
	ResetAllData() error

	// attune for a particular call
	WithContext(ctx context.Context) ExtensionManager
}
