package data

import (
	"context"
	"net/http"
)

// actual key is the address of this var, which is unique in program space
var managerKey int

// StoreManager builds a goji middleware that automatically places an
// ExtensionManager into the context of each request.
func StoreManager(manager ExtensionManager) func(http.Handler) http.Handler {
	return func(inner http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			ctx := Store(r.Context(), manager)
			inner.ServeHTTP(w, r.WithContext(ctx))
		})
	}
}

// Store places a manager into a context
func Store(ctx context.Context, mgr ExtensionManager) context.Context {
	return context.WithValue(ctx, &managerKey, mgr)
}

// Load retrieves a manager from a context
func Load(ctx context.Context) ExtensionManager {
	if value, ok := ctx.Value(&managerKey).(ExtensionManager); ok {
		return value.WithContext(ctx)
	}
	return &nullManager{}
}
