package data

import (
	"context"

	"code.justin.tv/gds/gds/extensions/ems/client/messages"
	"code.justin.tv/gds/gds/extensions/ems/documents"
	"code.justin.tv/gds/gds/extensions/ems/protocol"
	"code.justin.tv/gds/gds/golibs/event"
)

type nullManager struct{}

func (n *nullManager) WithContext(ctx context.Context) ExtensionManager {
	return n
}

func (*nullManager) CreateVersionOld(*documents.Manifest) error {
	return ErrUnavailable
}

func (*nullManager) CreateVersionV2(*protocol.ExtensionManifest) (Extension, error) {
	return nil, ErrUnavailable
}

func (*nullManager) CreateVersionV3(*protocol.ExtensionManifest) (Extension, error) {
	return nil, ErrUnavailable
}

func (*nullManager) AddAssetInfo(*protocol.AssetInfo) (AssetInfo, error) {
	return nil, ErrUnavailable
}

func (*nullManager) GetAllVersions(string) ([]Extension, error) {
	return nil, ErrUnavailable
}

func (*nullManager) PagedGetVersions(string, *string) ([]Extension, bool, *string, error) {
	return nil, false, nil, ErrUnavailable
}

func (*nullManager) GetExtensions(Request) ([]Extension, error) {
	return nil, ErrUnavailable
}

func (*nullManager) GetAssetInfo(string, string) (AssetInfo, error) {
	return nil, ErrUnavailable
}

func (*nullManager) GetChannel(string) (Channel, error) {
	return nil, ErrUnavailable
}

func (*nullManager) Fields() (*documents.SearchSortFieldsDocument, error) { return nil, ErrUnavailable }

func (*nullManager) FindExtensions(*SearchSettings, *documents.GetExtensionsParams) (*documents.ExtensionsDocument, error) {
	return nil, ErrUnavailable
}

func (*nullManager) DeleteExtensionsFromSearch([]string) (int, error) {
	return 0, ErrUnavailable
}

func (*nullManager) FindChannelInstalls(string) ([]*messages.ChannelMessage, error) {
	return nil, ErrUnavailable
}

func (*nullManager) DeleteChannelFromSearch(string) (int, error) {
	return 0, ErrUnavailable
}

func (*nullManager) Register(ev event.Listener) error {
	return ErrUnavailable
}

func (*nullManager) IsResetEnabled() bool {
	return false
}

func (*nullManager) ResetAllData() error {
	return ErrUnavailable
}

func (*nullManager) DeleteExtension(string) error {
	return ErrUnavailable
}

func (*nullManager) GetExtensionSummary(string) (*protocol.ExtensionSummary, error) {
	return nil, ErrUnavailable
}
