package data

type simpleRequest struct {
	id      string
	version *string
	used    bool
}

func (s *simpleRequest) Reset()                     { s.used = false }
func (s *simpleRequest) OnMissing() MissingBehavior { return MissingBehaviorError }
func (s *simpleRequest) Next() (string, *string, bool) {
	if s.used {
		return "", nil, false
	}
	s.used = true
	return s.id, s.version, true
}
