package auth

// FakeCredentials implement Credentials that can be used in unit testing
type FakeCredentials struct {
	AllowCurateAllCategories bool
	AllowEditAllCategories   bool
	AllowCurateAllGames      bool
	AllowSeeHiddenExtensions bool
	ClientIDValue            string
	UserIDValue              string
}

// NoPermissions returns a default credential that has no permissions
func NoPermissions() Credentials { return new(FakeCredentials) }

// CanCurateAllCategories returns true if the caller has global curate permissions
func (f *FakeCredentials) CanCurateAllCategories() bool { return f.AllowCurateAllCategories }

// CanEditAllCategories returns true if the caller has global edit permissions
func (f *FakeCredentials) CanEditAllCategories() bool { return f.AllowEditAllCategories }

// CanCurateAllGames returns true if the caller has global curate permissions
func (f *FakeCredentials) CanCurateAllGames() bool { return f.AllowCurateAllGames }

// CanSeeHiddenExtensions returns true if the caller has global ability to see hidden extensions
func (f *FakeCredentials) CanSeeHiddenExtensions() bool { return f.AllowSeeHiddenExtensions }
