package auth

import "context"

var (
	// this value is never used, the address is important
	credentialsMarker = 42
	// credentialsKey is a unique address within this process and private to this
	// package so that it can never be accidentally stepped on by other values.
	credentialsKey = &credentialsMarker
)

// Load retrieves Credentials from a context defaulting to NoPermissions()
func Load(ctx context.Context) Credentials {
	if cast, ok := ctx.Value(credentialsKey).(Credentials); ok {
		return cast
	}
	return NoPermissions()
}

// Store places Credentials into a context
func Store(ctx context.Context, creds Credentials) context.Context {
	return context.WithValue(ctx, credentialsKey, creds)
}
