package utils

import (
	"fmt"
	"sort"
)

type IntSet struct {
	m map[int]struct{}
}

func DistinctInts(values ...int) IntSet {
	m := make(map[int]struct{})
	for _, v := range values {
		m[v] = struct{}{}
	}
	return IntSet{m: m}
}

func (s *IntSet) Add(v int) bool {
	if s.m == nil {
		s.m = map[int]struct{}{
			v: struct{}{},
		}
		return true
	}
	if s.Contains(v) {
		return false
	}
	s.m[v] = struct{}{}
	return true
}

func (s *IntSet) Remove(v int) bool {
	if s.Contains(v) {
		delete(s.m, v)
		return true
	}
	return false
}

func (s *IntSet) Contains(v int) bool {
	if s.m == nil {
		return false
	}
	_, contains := s.m[v]
	return contains
}

func (s *IntSet) Len() int {
	return len(s.m)
}

func (s *IntSet) Values() []int {
	if s.Len() == 0 {
		return nil
	}
	values := make([]int, 0, s.Len())
	for v := range s.m {
		values = append(values, v)
	}
	sort.Ints(values)
	return values
}

func (s *IntSet) String() string {
	v := fmt.Sprint(s.Values())
	return fmt.Sprintf("{%s}", v[1:len(v)-1])
}
