package utils

// StringIn returns true if the string is exactly matched by an array element
func StringIn(val string, array []string) bool {
	for _, e := range array {
		if e == val {
			return true
		}
	}
	return false
}

func StringSubset(val []string, array []string) bool {
	for _, e := range val {
		if !StringIn(e, array) {
			return false
		}
	}
	return true
}

func EquivalentStringSlices(lhs, rhs []string) bool {
	if len(lhs) != len(rhs) {
		return false
	}
	return StringSubset(lhs, rhs)
}

func IntIn(val int, array []int) bool {
	for _, e := range array {
		if e == val {
			return true
		}
	}
	return false
}

func IntSubset(val []int, array []int) bool {
	for _, e := range val {
		if !IntIn(e, array) {
			return false
		}
	}
	return true
}

func EquivalentIntSlices(lhs, rhs []int) bool {
	if len(lhs) != len(rhs) {
		return false
	}
	return IntSubset(lhs, rhs)
}
