package utils

import "code.justin.tv/gds/gds/extensions/ems/protocol"

// Contains utility functions used in tests in multiple different packages which therefore need to not be in a
// *_test.go package since those do not get exported to other packages.

// CompareDiscoveryMetadata returns true if two DiscoveryMetadata objects match on the fields that should
// be changed from Set/CloneDiscoveryMetadata
// Returns false if either expected or actual are nil
func CompareDiscoveryMetadata(expected *protocol.DiscoveryMetadata, actual *protocol.DiscoveryMetadata) bool {
	if expected == nil || actual == nil {
		return false
	}
	if expected.AuthorName != actual.AuthorName {
		return false
	}
	if expected.Description != actual.Description {
		return false
	}
	if expected.EULATOSURL != actual.EULATOSURL {
		return false
	}
	if expected.Name != actual.Name {
		return false
	}
	if expected.PrivacyPolicyURL != actual.PrivacyPolicyURL {
		return false
	}
	if expected.Summary != actual.Summary {
		return false
	}
	if expected.SupportEmail != actual.SupportEmail {
		return false
	}
	if expected.ViewerSummary != actual.ViewerSummary {
		return false
	}
	if !EquivalentStringSlices(expected.Categories, actual.Categories) {
		return false
	}
	if !EquivalentIntSlices(expected.Games, actual.Games) {
		return false
	}

	return true
}
