package auth

import wp "code.justin.tv/gds/gds/extensions/whitelist/protocol"

// Credentials describes a permission set for using whitelists
type Credentials interface {
	CanListWhitelists() bool
	CanViewWhitelist(wp.Action) bool
	CanEditWhitelist(wp.Action) bool
	ClientID() string
	// UserID should return a pointer to a string if the userID is set, otherwise nil instead of pointer to ""
	UserID() *string
	// FlatUserID is like UserID but if the string is nil it returns "" instead
	FlatUserID() string
}
