package data

import (
	"context"
	"net/http"
)

// actual key is the address of this var, which is unique in program space
var whitelistKey int

// StoreManager builds a goji middleware that automatically places a
// WhitelistManager into the context of each request
func StoreManager(manager WhitelistManager) func(http.Handler) http.Handler {
	return func(inner http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			ctx := Store(r.Context(), manager)
			inner.ServeHTTP(w, r.WithContext(ctx))
		})
	}
}

// Store places a whitelist Source into a request context.
func Store(ctx context.Context, manager WhitelistManager) context.Context {
	return context.WithValue(ctx, &whitelistKey, manager)
}

// Load retrieves a whitelist WhitelistManager from a request context.
func Load(ctx context.Context) WhitelistManager {
	if value, ok := ctx.Value(&whitelistKey).(WhitelistManager); ok {
		return value.WithContext(ctx)
	}
	return &nullManager{}
}
