package data

import (
	"context"
	"math/rand"
	"time"

	"code.justin.tv/gds/gds/golibs/config"
)

// ClientDurationParam can be set force clients to idle
const ClientDurationParam = "ems.whitelist.client.cache.duration"

// NextClientExpiration calculates a jittered time for the client to expire
// based on the current context.
func NextClientExpiration(ctx context.Context) time.Time {
	cfg := config.Load(ctx)
	var refresh time.Duration
	if parsed, err := time.ParseDuration(cfg.GetString(ClientDurationParam, "0s")); err == nil {
		refresh = parsed
	}
	if refresh <= time.Duration(0) {
		return time.Time{}
	}
	jitter := 1 - rand.Float64()/10
	jittered := float64(refresh) * jitter
	return time.Now().Add(time.Duration(jittered))
}
