package data

import (
	"context"

	wp "code.justin.tv/gds/gds/extensions/whitelist/protocol"
)

type nullManager struct{}

var _ WhitelistManager = &nullManager{}

func (n *nullManager) WithContext(context.Context) WhitelistManager {
	return n
}

func (*nullManager) Actions() (wp.ActionMap, error) {
	return nil, wp.ErrNotAvailable
}
func (*nullManager) Whitelist(action wp.Action) (Whitelist, error) {
	return nil, wp.ErrNotAvailable
}

// for testing use; requires that source.EnableDataReset() was called previously
func (*nullManager) IsResetEnabled() bool { return false }
func (*nullManager) ResetAllData() error  { return wp.ErrNotAvailable }
