package data

import wp "code.justin.tv/gds/gds/extensions/whitelist/protocol"

// Whitelist implements a controller for whitelist management; this interface
// does not allow bulk actions because there is no safe way to perform them in
// the underlying data source.  This should be revisited when that is no longer
// true.
type Whitelist interface {
	Action() wp.Action
	Members(pagingToken *string) ([]wp.MemberRecord, *string, error)
	HasMember(member wp.Member) (bool, error)
	OnceHadMember(member wp.Member) (bool, error)

	Insert(reason string, member wp.Member) (*wp.MemberRecord, error)
	Remove(reason string, member wp.Member) error
	DeleteMember(member wp.Member) (*wp.MemberRecord, error)
}
