package data

import (
	"context"

	wp "code.justin.tv/gds/gds/extensions/whitelist/protocol"
)

// WhitelistManager is the starting point for interactions with the back end of
// the whitelist service.
type WhitelistManager interface {
	Actions() (wp.ActionMap, error)
	Whitelist(action wp.Action) (Whitelist, error)

	// for testing use; requires that source.EnableDataReset() was called previously
	IsResetEnabled() bool
	ResetAllData() error

	// WithContext is implicitly used by data.Load() to set context state
	// (auth, config) so that the manager has the correct information for each
	// call; it is a threadsafe operation that may return a duplicate of the
	// original object.
	WithContext(context.Context) WhitelistManager
}
