package protocol

import (
	"time"
)

const (
	// WhitelistProtocolString describes the currently supported whitelist protocol version
	WhitelistProtocolString = "application/ext.whitelists.1+json"
	// PageTokenQueryString is the string to pass for fetching the next page of members
	PageTokenQueryString = "page_token"
	// ReasonQueryString is the string to pass for setting the reason on an API write
	ReasonQueryString = "reason"
)

// MemberRecord defines information about a whitelist member
type MemberRecord struct {
	Member    Member    `json:"member"`
	AddedBy   Member    `json:"added_by"`
	AddedTime time.Time `json:"added_time"`
	Reason    string    `json:"reason"`
}

// WhitelistsResponse is the paged response to the GetWhitelists call
type WhitelistsResponse struct {
	Actions ActionMap `json:"actions"`
	Expires time.Time `json:"expires"`
}

// MembersResponse is the paged response to the GetMembers call
type MembersResponse struct {
	Action   Action         `json:"action"`
	Members  []MemberRecord `json:"members"`
	NextPage *string        `json:"next_page"`
	Expires  time.Time      `json:"expires"`
}

// HasMemberResponse is the response to the HasMember and RemoveMember calls
type HasMemberResponse struct {
	Action  Action    `json:"action"`
	Member  Member    `json:"member"`
	Found   bool      `json:"found"`
	Expires time.Time `json:"expires"`
}

// InsertResponse is the response to the InsertMember call
type InsertResponse struct {
	Action    Action    `json:"action"`
	Member    Member    `json:"member"`
	AddedBy   Member    `json:"added_by"`
	DateAdded time.Time `json:"date_added"`
	Reason    string    `json:"reason"`
	Expires   time.Time `json:"expires"`
}

// DeleteUserResponse represents response body guranteed by the request
type DeleteUserResponse struct {
	Deletions []string // Formated as: "id:whitelist"
	Errors    []error
}

// AuditUserResponse is the collection of whitelists the user is a member of
type AuditUserResponse struct {
	Whitelists []string // Formated as: "id:whitelist"
	Errors     []error
}
