## Cache

This library provides the ability to consolidate parallel requests into a single promise, debouncing read access to a server.  It does this by means of returning a promise for the requested data that is fulfilled when the underlying request is completed.  These promises are held by an in-memory cache with a service-specified duration; the two most common use cases will be simple removal of duplicate in-flight requests to reduce downstream load (set the cache timeout ~ 1 second) and actual memory caching of the requested value.

In order to use the cache, you need to implement the Source interface by creating a `GetForCache(key string) (interface{}, error)` function.  This function is responsible for all business logic you would expect if the cache was not present, e.g. supplying a proper mechanism to time out and unblock waiting customers with an error if necessary.
