package sources

type refreshableSource struct {
	logic   RefreshLogic
	current Source
}

// NewRefreshableSource is an adapter that converts a RefreshLogic into a
// RefreshableSource.
func NewRefreshableSource(settings Settings, logic RefreshLogic) (RefreshableSource, error) {
	src := &refreshableSource{logic: logic}
	if err := src.Refresh(settings); err != nil {
		return nil, err
	}
	return src, nil
}

func (r *refreshableSource) GetName() string                      { return r.current.GetName() }
func (r *refreshableSource) GetBool(name string) (bool, bool)     { return r.current.GetBool(name) }
func (r *refreshableSource) GetFloat(name string) (float64, bool) { return r.current.GetFloat(name) }
func (r *refreshableSource) GetInt(name string) (int64, bool)     { return r.current.GetInt(name) }
func (r *refreshableSource) GetString(name string) (string, bool) { return r.current.GetString(name) }
func (r *refreshableSource) GetAll() map[string]interface{}       { return r.current.GetAll() }

func (r *refreshableSource) Refresh(settings Settings) error {
	current, err := r.logic.GetValues(settings)
	if err != nil {
		return err
	}
	r.current = current
	return nil
}
