package discovery

import (
	"github.com/aws/aws-sdk-go/service/elasticsearchservice"
	"github.com/aws/aws-sdk-go/service/elasticsearchservice/elasticsearchserviceiface"
)

// ElasticSearchEndpointsByTag returns the list of ES Domain Endpoints with the given tag
func ElasticSearchEndpointsByTag(svc elasticsearchserviceiface.ElasticsearchServiceAPI, key, value string) ([]string, error) {
	resp, err := svc.ListDomainNames(&elasticsearchservice.ListDomainNamesInput{})
	if err != nil {
		return nil, err
	}
	domainNames := make([]*string, len(resp.DomainNames))
	for i, domain := range resp.DomainNames {
		domainNames[i] = domain.DomainName
	}
	descriptionsResp, err := svc.DescribeElasticsearchDomains(&elasticsearchservice.DescribeElasticsearchDomainsInput{
		DomainNames: domainNames,
	})
	if err != nil {
		return nil, err
	}

	foundEndpoints := []string{}

	for _, description := range descriptionsResp.DomainStatusList {
		tagResp, err := svc.ListTags(&elasticsearchservice.ListTagsInput{
			ARN: description.ARN,
		})
		if err != nil {
			return nil, err
		}
		for _, tag := range tagResp.TagList {
			if *tag.Key == key && *tag.Value == value {
				foundEndpoints = append(foundEndpoints, *description.Endpoint)
			}
		}
	}

	return foundEndpoints, nil
}
