package discovery

import (
	"github.com/aws/aws-sdk-go/service/rds"
	"github.com/aws/aws-sdk-go/service/rds/rdsiface"
)

// RDSEndpointsByTag returns the list of RDS Endpoints with the given tag
func RDSEndpointsByTag(svc rdsiface.RDSAPI, key, value string) ([]string, error) {
	resp, err := svc.DescribeDBInstances(&rds.DescribeDBInstancesInput{})
	if err != nil {
		return nil, err
	}
	foundEndpoints := []string{}

	for _, instance := range resp.DBInstances {
		tagResp, err := svc.ListTagsForResource(&rds.ListTagsForResourceInput{
			ResourceName: instance.DBInstanceArn,
		})
		if err != nil {
			return nil, err
		}
		for _, tag := range tagResp.TagList {
			if *tag.Key == key && *tag.Value == value {
				foundEndpoints = append(foundEndpoints, *instance.Endpoint.Address)
			}
		}
	}

	return foundEndpoints, nil
}
