package event

import "fmt"

type UnregisteredMessageTypeError struct {
	topic  Topic
	change Change
}

func NewUnregisteredMessageTypeError(msg Message) error {
	return &UnregisteredMessageTypeError{msg.Topic(), msg.Change()}
}

func (e UnregisteredMessageTypeError) Error() string {
	return fmt.Sprintf("Unregistered message type %v, %v", e.topic, e.change)
}
