package event

import "fmt"

var _ error = UnsupportedFormatVersionError{}

type UnsupportedMessageTypeError struct {
	topic  Topic
	change Change
}

func NewUnsupportedMessageTypeError(msg Message) error {
	return UnsupportedMessageTypeError{msg.Topic(), msg.Change()}
}

func (e UnsupportedMessageTypeError) Error() string {
	return fmt.Sprintf("Message type %v, %v is not supported", e.topic, e.change)
}
