package operation

import (
	"code.justin.tv/video/metrics-middleware/v2/operation"
)

type Kind = operation.Kind

const (
	// KindSpan is a generic operation. It can be used to split up processing
	// within a single program.
	KindSpan Kind = operation.KindSpan

	// KindServer represents a request inbound to the current program.
	KindServer Kind = operation.KindServer

	// KindClient describes a request created by the current program which
	// will be processed elsewhere.
	KindClient Kind = operation.KindClient
)

type Name = operation.Name

// Status describes the result of an Op.
type Status = operation.Status

// An Op describes an operation that is currently in progress. This view of
// the operation provides the ability to set the status of the operation and
// to mark it as complete.
//
// Most code should will report information about the operation through the
// View type.
type Op = operation.Op

// MonitorPoints is a set of optional callbacks that let an OpMonitor keep
// track of an Op's lifecycle.
//
// Unused callbacks may be left as nil.
type MonitorPoints = operation.MonitorPoints

// A Report describes an operation that has finished.
type Report = operation.Report

// An OpMonitor passively observes an Op. It has an opportunity to modify the
// Context to be used for the Op, such as to add request-tracing data. The
// functions on the returned MonitorPoints are called during the request
// lifecycle; implementors should provide functions for any points they'd like
// to monitor or -- within limits -- to affect.
type OpMonitor = operation.OpMonitor
