package operation

import (
	"context"

	"code.justin.tv/video/metrics-middleware/v2/operation"
)

// A View provides limited access to an Op. It is generally attached to a
// Context value, so may be available to functions that are incidentally
// involved in processing the operation.
//
// Since View does not allow access to "dangerous" methods on Op such as
// "End", it can be safely used wherever Context values are appropriate.
type View = operation.View

// ViewFromContext returns the View value attached to ctx, or nil if none is
// attached.
func ViewFromContext(ctx context.Context) *View {
	return operation.ViewFromContext(ctx)
}

// NewViewContext returns a Context with the provided View attached.
func NewViewContext(ctx context.Context, view *View) context.Context {
	return operation.NewViewContext(ctx, view)
}
