package cartman

import (
	"context"
	"net/http"

	"code.justin.tv/foundation/twitchclient"
)

// ActionsResponse defines the response of a request to /permitted_actions
type ActionsResponse struct {
	StatusCode int
	Permitted  PermittedActions
}

// PermittedActions defines the map of capabilities to their respective
// authorizations
type PermittedActions struct {
	Capabilities map[string]bool `json:"permitted_actions"`
}

const (
	actionsRequest = "permitted_actions"
)

// GetPermittedActions builds a request to Cartman's /permitted_actions
// endpoint and returns the binary data returned in the response of that
// request
func (c *client) GetPermittedActions(ctx context.Context, rp RequestParams, reqOpts *twitchclient.ReqOpts) (*ActionsResponse, error) {
	actions := ActionsResponse{StatusCode: http.StatusOK}
	req, err := c.buildRequest(ctx, rp, actionsRequest)
	if err != nil {
		return nil, err
	}

	combinedReqOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cartman.get_permitted_actions",
		StatSampleRate: defaultStatSampleRate,
	})

	var resp PermittedActions
	res, err := c.DoJSON(ctx, &resp, req, combinedReqOpts)
	if _, ok := err.(*twitchclient.Error); ok {
		actions.StatusCode = res.StatusCode
		return &actions, err
	}
	actions.Permitted = resp
	return &actions, nil
}
