#What?

This package comes with an example ECS service. ECS task setup is managed via CloudFormation.

The CloudFormation is in `configuration/cloudFormation`. You set these parameters in your LPT package.

## Parameters you can set:
*  CPU: Defaults to `256`. The number of `cpu` units used by the task. You should [read the Fargate docs](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-cpu) on this parameter as it controls how much CPU and Memory you can set.
   For the impatient:
   ```
      256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB

      512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB

      1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB

      2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments

      4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments

    ```
*  Memory: Defaults to: `512` in MB See above for available settings.
*  ServiceContainerPort: Defaults to: `8080`. The port your container will listen on. We auto-wire an NLB and ALB in front of your service; these terminate on the container at this port.
*  ServiceDesiredCount: Defaults to: `1`.  The desired number of containers.
*  Substage: Defaults to: `'primary'`. The substage of your container. We recommend keeping this as `'primary'`, see the Fulton Docs for more info on this.

## Parameters not to mess with:

All of these parameters are set via LPT so you probably don't want to modify these:

*  Stage: Defaults to: `'beta'`. The logical stage of your container; you probably don't want to override this as we set it in LPT based on the stage of your Pipeline
*  UseBatsKeyParam: Defaults to `false`. Don't mess with this as it will lead to issues getting your S3 bucket for deployment purposes.
*  ImageTag: Pipelines will compute this for you as it replicates build artifacts - the Docker image to deploy to ECS
*  ImageDigest: Pipelines will compute this for you as it replicates build artifacts - the SHA of the Docker image.
*  DeploymentBucketImportName: We compute this for you, this is where you set which bucket to pull your deployment from.
*  PipelinesControlledEcrRespository: We fill this for you.

## Changing LPT parameters

You edit CloudFormation stack parameters in your service's LPT package, in the `stack_params_for_options` method. Run `brazil-build synthesize-pipeline`, and kick off a build in your ECS pipeline to see the new values take effect.

This package uses [CfnBuild](https://code.amazon.com/packages/CfnBuild) to build the final CloudFormation templates it uses. See the README in [CfnBuild](https://code.amazon.com/packages/CfnBuild) for details. 

This package comes with some other goodies out of the box, we have [SAMToolkit](https://w.amazon.com/index.php/SAMToolkit) built in, as well as [Rapid Dev Environment](https://w.amazon.com/index.php/RDE).

# The Example ECS service

The example ECS service gets and updates pricing data in a DynamoDB table.

# Service Development and Testing
See the Fulton Doc on [Creating a Workspace and Building Packages](https://docs.fulton.twitch.a2z.com/docs/creating_workspace_building_packages.html)
for building your service and the Fulton Doc on [Testing Your Code](https://docs.fulton.twitch.a2z.com/docs/testing_code.html)
for general testing workflows.
