package main

// See https://docs.fulton.twitch.a2z.com/docs/integration_tests.html for more information on how integration tests work
import (
	"log"
	"os"
	"testing"
)

var (
	region string
	stage  string
)

// TestMain test setup.
func TestMain(m *testing.M) {
	if os.Getenv("HYDRA") == "" {
		// Noop since this means we are likely trying to run integration tests as part of unit testing
		log.Println("Not running integration tests under HYDRA, terminate")
		os.Exit(0)
	}

	region = "us-west-2"
	if r := os.Getenv("LOGICAL_STAGE_NAME"); r != "" {
		region = r
	} else if r := os.Getenv("AWS_DEFAULT_REGION"); r != "" {
		region = r
	} else if r := os.Getenv("AWS_REGION"); r != "" {
		region = r
	}

	stage = "beta"
	if s := os.Getenv("LOGICAL_STAGE_NAME"); s != "" {
		stage = s
	}

	retCode := m.Run()

	os.Exit(retCode)
}
