package data

import (
	"context"

	"code.justin.tv/extensions/fulton-configuration/protocol"
)

type ConfigurationManager interface {
	WithContext(ctx context.Context) ConfigurationManager

	Get(addresses ...protocol.Address) (protocol.RecordMap, error)
	GetByChannel(channelID string, includeCommon bool, extensionIDs ...string) (protocol.RecordMap, error)
	DeleteByChannel(channelID string) error
	ForExtension(extensionID string) (ExtensionConfiguration, error)
}
