package data

import (
	"net/http"

	"code.justin.tv/gds/gds/golibs/awsutil"
	"code.justin.tv/gds/gds/golibs/errors/errconv"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"code.justin.tv/extensions/fulton-configuration/protocol"
)

type errConverter struct{}

var (
	_         errconv.Converter = (*errConverter)(nil)
	fallback                    = errconv.NewTypeConverter()
	converter                   = &errConverter{}
)

func NewErrorConverter() errconv.Converter {
	return &errConverter{}
}

// TODO : wrap params.ErrMissingBody
// TODO : wrap JSON parse errors
func (*errConverter) Convert(err error) error {
	switch awsutil.GetCode(err) {
	case dynamodb.ErrCodeConditionalCheckFailedException:
		return protocol.ErrConcurrency
	case dynamodb.ErrCodeProvisionedThroughputExceededException:
		return protocol.ErrTooManyRequests
	}
	return fallback.Convert(err)
}

// TODO : centralize this middleware functionality in golibs
func StoreErrorConverter() func(http.Handler) http.Handler {
	return func(inner http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			ctx := errconv.StoreConverter(r.Context(), converter)
			inner.ServeHTTP(w, r.WithContext(ctx))
		})
	}
}
