package data

import (
	"context"
	"net/http"
)

// actual key is the address of this var, which is unique in program space
var managerKey int

// StoreManager builds a goji middleware that automatically places an
// ExtensionManager into the context of each request.
func StoreManager(manager ConfigurationManager) func(http.Handler) http.Handler {
	return func(inner http.Handler) http.Handler {
		return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			ctx := Store(r.Context(), manager)
			inner.ServeHTTP(w, r.WithContext(ctx))
		})
	}
}

// Store places a manager into a context
func Store(ctx context.Context, mgr ConfigurationManager) context.Context {
	return context.WithValue(ctx, &managerKey, mgr)
}

// Load retrieves a manager from a context and updates the manager's contextual
// data to match its local use
func Load(ctx context.Context) ConfigurationManager {
	if value, ok := ctx.Value(&managerKey).(ConfigurationManager); ok {
		return value.WithContext(ctx)
	}
	return &nullManager{}
}
