package bad

import (
	"net/http"

	"code.justin.tv/gds/gds/golibs/errors"
	"code.justin.tv/extensions/fulton-configuration/data/model"
)

// ErrExpected is returned from all bad store calls
var ErrExpected = errors.NewBuilder("ErrExpected").WithHTTPStatus(http.StatusNotImplemented).WithErrorCode("ErrExpected").Build()

type store struct{}

// New returns a new implementation of a store that always fails
func New() model.StoreWithTracker {
	return &store{}
}

func (*store) AsyncLoadCommon(extensionID, envirionment string) model.CommonPromise {
	return model.NewErrorPromise(ErrExpected)
}

func (*store) AsyncLoadChannel(channelID, extensionID, environment string) model.ChannelPromise {
	return model.NewErrorPromise(ErrExpected)
}

func (*store) LoadCommon(extensionID, environment string) (*model.Common, error) {
	return nil, ErrExpected
}

func (*store) LoadChannel(channelID, extensionID, environment string) (*model.Channel, error) {
	return nil, ErrExpected
}

func (*store) SaveCommon(g *model.Common) error     { return ErrExpected }
func (*store) SaveChannel(c *model.Channel) error   { return ErrExpected }
func (*store) DeleteChannel(channelID string) error { return ErrExpected }

func (*store) MarkCommonPublished(g *model.Common) error   { return ErrExpected }
func (*store) MarkChannelPublished(c *model.Channel) error { return ErrExpected }

func (*store) Block(channelID string) error              { return ErrExpected }
func (*store) Unblock(channelID string) error            { return ErrExpected }
func (*store) OnDeletionFinished(channelID string) error { return ErrExpected }
func (*store) IsBlocked(channelID string) model.BlockPromise {
	return model.NewErrorPromise(ErrExpected)
}
func (*store) DeletionInProgress() ([]string, error) { return []string{}, ErrExpected }

func (*store) IsResetEnabled() bool { return false }
func (*store) EnableDataReset()     {}
func (*store) ResetAllData() error  { return ErrExpected }
