package model

// BlockTracker is a Resetable BlockTrackerFuncs
type BlockTracker interface {
	BlockTrackerFuncs
	Resetable
}

// BlockTrackerFuncs allows the ability to block configuration segments by channel,
// allowing users to specify they should be forgotten by extensions
type BlockTrackerFuncs interface {
	Block(channelID string) error
	Unblock(channelID string) error
	OnDeletionFinished(channelID string) error
	IsBlocked(channelID string) BlockPromise
	DeletionInProgress() ([]string, error)
}
