package dynamo

import (
	"sync"

	"code.justin.tv/gds/gds/golibs/dynamodb/aggregator"
	"code.justin.tv/extensions/fulton-configuration/data/model"
)

type blockPromise struct {
	inner     aggregator.Promise
	unmarshal UnmarshalFunc
	once      sync.Once
	record    *blockRecord
	err       error
}

var _ model.BlockPromise = (*blockPromise)(nil)

func newBlockPromise(inner aggregator.Promise, unmarshal UnmarshalFunc) *blockPromise {
	return &blockPromise{inner: inner, unmarshal: unmarshal}
}

func (p *blockPromise) WouldBlock() bool          { return p.inner.WouldBlock() }
func (p *blockPromise) Get() (interface{}, error) { return p.Active() }
func (p *blockPromise) Active() (bool, error) {
	block, err := p.block()
	if block == nil {
		return false, err
	}
	return block.Activated != nil, err
}

func (p *blockPromise) block() (*blockRecord, error) {
	p.once.Do(p.resolve)
	return p.record, p.err
}

func (p *blockPromise) resolve() {
	data, err := p.inner.GetData()
	if err != nil {
		p.err = err
	} else if len(data) > 0 {
		p.record = new(blockRecord)
		p.err = p.unmarshal(data, p.record)
	}
}
