package dynamo

import (
	"testing"
	"time"

	"code.justin.tv/gds/gds/golibs/dynamodb/lazy"
	"github.com/stretchr/testify/assert"
	"code.justin.tv/extensions/fulton-configuration/data/model/bad"
)

func TestBlockPromise(t *testing.T) {
	t.Run("should handle unset correctly", func(t *testing.T) {
		d := new(dummyPromise)
		d.block = true
		p := newBlockPromise(d, lazy.UnmarshalMap)
		assert.True(t, p.WouldBlock())
	})

	t.Run("should handle set correctly", func(t *testing.T) {
		now := time.Now()
		src := &blockRecord{ChannelID: "chID", Activated: &now}
		d := new(dummyPromise)
		d.data, d.err = lazy.MarshalMap(src)
		p := newBlockPromise(d, lazy.UnmarshalMap)
		assert.False(t, p.WouldBlock())

		i, e := p.Get()
		assert.Equal(t, true, i)
		assert.NoError(t, e)

		out, e := p.Active()
		assert.True(t, out)
		assert.NoError(t, e)
	})

	t.Run("should handle empty correctly", func(t *testing.T) {
		d := new(dummyPromise)
		d.data, d.err = lazy.MarshalMap(nil)
		p := newBlockPromise(d, lazy.UnmarshalMap)
		assert.False(t, p.WouldBlock())
		i, e := p.Get()
		assert.Equal(t, false, i)
		assert.NoError(t, e)

		out, e := p.Active()
		assert.False(t, out)
		assert.NoError(t, e)
	})

	t.Run("should handle errored correctly", func(t *testing.T) {
		d := &dummyPromise{err: bad.ErrExpected}
		p := newBlockPromise(d, lazy.UnmarshalMap)
		assert.False(t, p.WouldBlock())
		i, e := p.Get()
		assert.Equal(t, false, i)
		assert.Equal(t, bad.ErrExpected, e)

		out, e := p.Active()
		assert.False(t, out)
		assert.Equal(t, bad.ErrExpected, e)
	})
}
