package dynamo

import (
	"sync"

	"code.justin.tv/gds/gds/golibs/dynamodb/aggregator"
	"code.justin.tv/extensions/fulton-configuration/data/model"
	"code.justin.tv/extensions/fulton-configuration/data/model/shared"
)

type commonPromise struct {
	inner     aggregator.Promise
	unmarshal UnmarshalFunc
	once      sync.Once
	common    *model.Common
	err       error
}

func newCommonPromise(inner aggregator.Promise, unmarshal UnmarshalFunc) shared.BaseCommonPromise {
	return &commonPromise{inner: inner, unmarshal: unmarshal}
}

func (p *commonPromise) WouldBlock() bool          { return p.inner.WouldBlock() }
func (p *commonPromise) Get() (interface{}, error) { return p.Common() }
func (p *commonPromise) Common() (*model.Common, error) {
	p.once.Do(p.resolve)
	return p.common, p.err
}

func (p *commonPromise) resolve() {
	data, err := p.inner.GetData()
	if err != nil {
		p.err = err
	} else if len(data) > 0 {
		p.common = new(model.Common)
		p.err = p.unmarshal(data, p.common)
	}
}
