package dynamo

import (
	"testing"

	"code.justin.tv/gds/gds/golibs/dynamodb/lazy"
	"code.justin.tv/gds/gds/golibs/uuid"
	"github.com/stretchr/testify/assert"
	"code.justin.tv/extensions/fulton-configuration/data/model/bad"
)

type mockUUID struct{}

var _ uuid.Source = (*mockUUID)(nil)

func (*mockUUID) Next() (string, error) { return "", bad.ErrExpected }

func TestMarshalForSave(t *testing.T) {
	t.Run("forwards uuid errors", func(t *testing.T) {
		out, uuid, err := MarshalForSave(nil, &mockUUID{}, lazy.MarshalMap)
		assert.Nil(t, out)
		assert.Empty(t, uuid)
		assert.Equal(t, bad.ErrExpected, err)
	})
}
