package memory

import (
	"code.justin.tv/gds/gds/golibs/cache"
	"code.justin.tv/extensions/fulton-configuration/data/model"
	"code.justin.tv/extensions/fulton-configuration/data/model/shared"
	"code.justin.tv/extensions/fulton-configuration/protocol"
)

type channelPromise struct {
	inner *cache.SimplePromise
}

var _ shared.BaseChannelPromise = (*channelPromise)(nil)

func newChannelPromise() *channelPromise { return &channelPromise{cache.NewPromise()} }

func (c *channelPromise) WouldBlock() bool          { return c.inner.WouldBlock() }
func (c *channelPromise) Get() (interface{}, error) { return c.inner.Get() }
func (c *channelPromise) Channel() (*model.Channel, error) {
	data, err := c.inner.Get()
	if data == nil || err != nil {
		return nil, err
	}
	if channel, ok := data.(*model.Channel); ok {
		return channel, err
	}
	return nil, protocol.ErrUnavailable
}
