package memory

import (
	"code.justin.tv/gds/gds/golibs/cache"
	"code.justin.tv/extensions/fulton-configuration/data/model"
	"code.justin.tv/extensions/fulton-configuration/data/model/shared"
	"code.justin.tv/extensions/fulton-configuration/protocol"
)

type commonPromise struct {
	inner *cache.SimplePromise
}

var _ shared.BaseCommonPromise = (*commonPromise)(nil)

func newCommonPromise() *commonPromise { return &commonPromise{cache.NewPromise()} }

func (c *commonPromise) WouldBlock() bool          { return c.inner.WouldBlock() }
func (c *commonPromise) Get() (interface{}, error) { return c.inner.Get() }
func (c *commonPromise) Common() (*model.Common, error) {
	data, err := c.inner.Get()
	if data == nil || err != nil {
		return nil, err
	}
	if common, ok := data.(*model.Common); ok {
		return common, err
	}
	return nil, protocol.ErrUnavailable
}
