package memory

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"code.justin.tv/extensions/fulton-configuration/data/model"
	"code.justin.tv/extensions/fulton-configuration/data/model/bad"
	"code.justin.tv/extensions/fulton-configuration/protocol"
)

func TestCommonPromise(t *testing.T) {
	t.Run("should handle unset correctly", func(t *testing.T) {
		p := newCommonPromise()
		assert.True(t, p.WouldBlock())
	})

	t.Run("should handle set correctly", func(t *testing.T) {
		p := newCommonPromise()
		in := model.NewCommon("env", "extID")
		p.inner.Set(in, nil)
		assert.False(t, p.WouldBlock())
		i, e := p.Get()
		assert.Equal(t, in, i)
		assert.NoError(t, e)

		out, e := p.Common()
		assert.Equal(t, in, out)
		assert.NoError(t, e)
	})

	t.Run("should handle mis-set correctly", func(t *testing.T) {
		p := newCommonPromise()
		p.inner.Set("wrong", nil)
		assert.False(t, p.WouldBlock())
		i, e := p.Get()
		assert.Equal(t, "wrong", i)
		assert.NoError(t, e)

		out, e := p.Common()
		assert.Nil(t, out)
		assert.Equal(t, protocol.ErrUnavailable, e)
	})

	t.Run("should handle empty correctly", func(t *testing.T) {
		p := newCommonPromise()
		p.inner.Set(nil, nil)
		assert.False(t, p.WouldBlock())
		i, e := p.Get()
		assert.Nil(t, i)
		assert.NoError(t, e)

		out, e := p.Common()
		assert.Nil(t, out)
		assert.NoError(t, e)
	})

	t.Run("should handle errored correctly", func(t *testing.T) {
		p := newCommonPromise()
		p.inner.Set(nil, bad.ErrExpected)
		assert.False(t, p.WouldBlock())
		i, e := p.Get()
		assert.Nil(t, i)
		assert.Equal(t, bad.ErrExpected, e)

		out, e := p.Common()
		assert.Nil(t, out)
		assert.Equal(t, bad.ErrExpected, e)
	})
}
