package model

import (
	"code.justin.tv/gds/gds/golibs/cache"
	"code.justin.tv/extensions/fulton-configuration/protocol"
)

type RecordPromise interface {
	cache.Promise
	Record() (*protocol.Address, *protocol.Record, error)
}

type MultiRecordPromise interface {
	cache.Promise
	ForSegment(segment protocol.SegmentType) RecordPromise
}

type CommonPromise interface {
	MultiRecordPromise
	Common() (*Common, error)
}

type ChannelPromise interface {
	MultiRecordPromise
	Channel() (*Channel, error)
}

type BlockPromise interface {
	cache.Promise
	Active() (bool, error)
}
