package model

import "code.justin.tv/extensions/fulton-configuration/protocol"

// recordForStorage allows the serialization process to create dynamo serialize
// the immutable Record type that is sealed in protocol without forcing the
// client to include the aws sdk.
type recordForStorage struct {
	Content *string `dynamodbav:",omitempty"`
	Version string  `dynamodbav:",omitempty"`
}

func toStorage(r *protocol.Record) *recordForStorage {
	if r == nil {
		return nil
	}
	return &recordForStorage{r.Content(), r.Version()}
}

func fromStorage(r *recordForStorage) *protocol.Record {
	if r == nil {
		return nil
	}
	return protocol.NewRecord(r.Version, r.Content)
}
