package data

import (
	"testing"

	"github.com/stretchr/testify/assert"
	"code.justin.tv/extensions/fulton-configuration/protocol"
)

func TestNullManager(t *testing.T) {
	var m nullManager
	var out interface{}

	out, err := m.Get()
	assert.Nil(t, out)
	assert.Equal(t, protocol.ErrUnimplemented, err)

	out, err = m.GetByChannel("", false)
	assert.Nil(t, out)
	assert.Equal(t, protocol.ErrUnimplemented, err)

	out, err = m.ForExtension("")
	assert.Nil(t, out)
	assert.Equal(t, protocol.ErrUnimplemented, err)

	assert.Equal(t, protocol.ErrUnimplemented, m.DeleteByChannel(""))
}
