package listeners

import (
	"testing"

	"code.justin.tv/gds/gds/golibs/errors"
	"code.justin.tv/gds/gds/golibs/event"
	gsns "code.justin.tv/gds/gds/golibs/event/sns"
	"github.com/aws/aws-sdk-go/service/sns"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	"code.justin.tv/extensions/fulton-configuration/protocol/messages"
)

func TestEventBusListener(t *testing.T) {
	dummy := gsns.NewMockSNS(nil)
	listener := NewEventBusListener(dummy, "unit_test", "chARN")
	assert.NoError(t, listener.OnMessages([]event.Message{}))
	assert.Len(t, listener.GetTopics(), 1)
	assert.Empty(t, dummy.Inputs())

	msg := messages.NewConfigMessage(1, messages.OnSet)
	msg2 := messages.NewConfigMessage(2, messages.OnSet)
	assert.NoError(t, listener.OnMessages([]event.Message{msg, msg2}))
	inputs := dummy.Inputs()
	require.Len(t, inputs, 2)

	verify(t, inputs[0], origin, configEvent, "unit_test", "chARN")
	verify(t, inputs[1], origin, configEvent, "unit_test", "chARN")

	expected := errors.NewBuilder("expected").Build()
	dummy.SetError(expected)
	assert.Equal(t, expected, listener.OnMessages([]event.Message{msg}))
}

func verify(t *testing.T, in *sns.PublishInput, src, event, env, arn string) {
	atts := in.MessageAttributes
	require.NotNil(t, in.TopicArn)
	assert.Equal(t, arn, *in.TopicArn)
	require.NotEmpty(t, atts["origin"])
	require.NotEmpty(t, atts["event"])
	require.NotEmpty(t, atts["environment"])
	require.NotNil(t, atts["origin"].StringValue)
	require.NotNil(t, atts["event"].StringValue)
	require.NotNil(t, atts["environment"].StringValue)
	assert.Equal(t, src, *atts["origin"].StringValue)
	assert.Equal(t, event, *atts["event"].StringValue)
	assert.Equal(t, env, *atts["environment"].StringValue)
}
