package protocol

type ExpandedRecord struct {
	Segment Segment `json:"segment"`
	Record  *Record `json:"record"`
}

func RecordMapToPublicReturn(data RecordMap) (map[string]*ExpandedRecord, error) {
	segmentMap := make(map[string]*ExpandedRecord)
	for address, record := range data {
		seg, err := address.Segment()
		if err != nil {
			return nil, err
		}
		segmentMap[seg.String()] = &ExpandedRecord{seg, record}
	}
	return segmentMap, nil
}
